// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The dispatch service provider free form labels window.
 */

//{namespace name="backend/viison_shipping_common_free_form_labels/main"}
Ext.define('Shopware.apps.ViisonShippingCommonFreeFormLabels.view.Window', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Enlight.app.Window',

    /**
     * The given xtype for shorthand syntax
     */
    xtype: 'viison-shipping-common-free-form-labels-window',

    /**
     * The grid panel used for creation
     */
    gridView: 'Shopware.apps.ViisonShippingCommonOrder.view.list.Label',

    /**
     * Add padding.
     */
    padding: 10,

    /**
     * Supports return labels.
     */
    doesSupportReturnLabel: true,

    /**
     * Define the layout position
     */
    layout: {
        type: 'vbox',
        align: 'stretch'
    },

    /**
     * Contains all snippets for the view component.
     */
    snippets: {
        gridTitle: '{s name="panel/grid_title"}{/s}',
        addLabelButton: {
            title: '{s name="panel/add_label_button/title"}{/s}',
            tooltip: '{s name="panel/add_label_button/tooltip"}{/s}'
        },
        addReturnLabelButton: {
            title: '{s name="panel/add_return_label_button/title"}{/s}',
            tooltip: '{s name="panel/add_return_label_button/tooltip"}{/s}'
        },
        loadMaskMessage: '{s name="panel/loadMask"}{/s}'
    },

    constructor: function() {
        var me = this;

        this.callParent(arguments);

        // Determine the window height automatically from its contents
        me.height = undefined;
    },

    /**
     * The default initializer, which adds the form fields to this form panel.
     */
    initComponent: function() {
        var me = this;

        // Create a hidden load mask
        me.loadMask = new Ext.LoadMask(me, {
            msg: me.snippets.loadMaskMessage
        });
        me.loadMask.hide();

        // Initialize a new shipping label store and load all labels that aren't assigned to an order
        me.shippingLabelStore = Ext.create(me.shippingLabelStoreClass);

        me.shippingLabelStore.getProxy().extraParams = {
            orderId: null
        };
        me.shippingLabelStore.loadPage(1);

        me.items = [
            me.createToolbar(),
            me.createLabelGrid()
        ];

        me.callParent(arguments);
    },

    /**
     * Creates a toolbar containing a button to add labels.
     *
     * @return The created toolbar.
     */
    createToolbar: function() {
        var me = this;

        // Add label button
        me.addLabelButton = Ext.create('Ext.button.Button', {
            iconCls: 'sprite-plus-circle-frame',
            text: me.snippets.addLabelButton.title,
            action: 'showLabelConfirmWindow',
            tooltip: me.snippets.addLabelButton.tooltip,
            handler: function() {
                me.fireEvent('showLabelConfirmWindow', me, null, me.shippingLabelStore);
            }
        });
        var items = [
            me.addLabelButton
        ];

        if (me.doesSupportReturnLabel) {
            // Add return label button
            me.addReturnLabelButton = Ext.create('Ext.button.Button', {
                iconCls: 'sprite-arrow-return-180',
                text: me.snippets.addReturnLabelButton.title,
                action: 'addReturnLabel',
                tooltip: me.snippets.addReturnLabelButton.tooltip,
                handler: function () {
                    me.fireEvent('showReturnLabelConfirmWindow', me, null, me.shippingLabelStore);
                }
            });
            items.push(
                { xtype: 'tbfill' },
                me.addReturnLabelButton
            );
        }

        // Create toolbar and add buttons
        return Ext.create('Ext.toolbar.Toolbar', {
            dock: 'top',
            ui: 'shopware-ui',
            margin: '0 0 10px 0',
            style: {
                padding: 0,
                backgroundColor: 'transparent'
            },
            items: items
        });
    },

    /**
     * Creates the label grid displaying all generated labels.
     *
     * @return The created grid.
     */
    createLabelGrid: function() {
        var me = this;

        var list = Ext.create(me.gridView || 'Shopware.apps.ViisonShippingCommonOrder.view.list.Label', {
            store: me.shippingLabelStore,
            record: me.record,
            dispatchServiceProviderPanel: me,
            showCustomerAddress: true,
            minHeight: 250,
            minWidth: 250,
            region: 'center',
            title: me.snippets.gridTitle,
            style: {
                'margin-bottom': '10px'
            }
        });

        return list;
    }

});
