// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

//{namespace name=backend/viison_shipping_common_grid_label_printing/main}
Ext.define('Shopware.apps.ViisonShippingCommonGridLabelPrinting.view.TemplateChooser', {

    commonSnippets: {
        fields: {
            startX: {
                label: '{s name="template_chooser/fields/start_x/label"}{/s}',
                help: '{s name="template_chooser/fields/start_x/help"}{/s}'
            },
            startY: {
                label: '{s name="template_chooser/fields/start_y/label"}{/s}',
                help: '{s name="template_chooser/fields/start_y/help"}{/s}'
            },
            template: {
                label: '{s name="template_chooser/fields/template/label"}{/s}'
            }
        }
    },

    createTemplateComponents: function() {
        var me = this;

        // Create the template store
        me.templateStore = Ext.create(me.templateClass, {});

        // Create the template selection
        me.templateSelection = Ext.create('Ext.form.field.ComboBox', {
            fieldLabel: me.commonSnippets.fields.template.label,
            name: 'template',
            store: this.templateStore,
            queryMode: 'local',
            displayField: 'title',
            valueField: 'name',
            width: 340,
            listeners: {
                select: function(comboBox, records) {
                    // Update the max values of the start position fields
                    me.resetStartPositionFields(records[0]);
                }
            }
        });

        // Create the start position fields
        me.startYField = Ext.create('Ext.form.field.Number', {
            fieldLabel: me.commonSnippets.fields.startY.label,
            helpText: me.commonSnippets.fields.startY.help,
            name: 'startY',
            value: 1,
            minValue: 1,
            maxValue: 16,
            allowDecimals: false,
            anchor: '100%'
        });

        me.startXField = Ext.create('Ext.form.field.Number', {
            fieldLabel: me.commonSnippets.fields.startX.label,
            helpText: me.commonSnippets.fields.startX.help,
            name: 'startX',
            value: 1,
            minValue: 1,
            maxValue: 5,
            allowDecimals: false,
            anchor: '100%'
        });

        // Load the templates
        me.templateStore.load({
            callback: function(records, operation, success) {
                // Select the default element
                for (var i = 0; i < records.length; i++) {
                    if (records[i].get('default')) {
                        // Update the selection
                        me.templateSelection.setValue(records[i].get('name'));
                        // Update the max values of the start position fields
                        me.resetStartPositionFields(records[i]);
                        break;
                    }
                };
            }
        });
    },

    /**
     * Updates the maximum values of the start position fields and, in case
     * a currently selected value exceeds these limits, resets both fields to one.
     *
     * @param record The newly selected GridLabelTemplate record.
     */
    resetStartPositionFields: function(record) {
        var me = this;

        // Update the maximum values
        me.startYField.setMaxValue(record.get('numRows'));
        me.startXField.setMaxValue(record.get('numCols'));
        if (me.startYField.getValue() > record.get('numRows') || me.startXField.getValue() > record.get('numCols')) {
            // Reset the values
            me.startXField.setValue(1);
            me.startYField.setValue(1);
        }
    }

});
