// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

//{namespace name="backend/viison_shipping_common_index_popup/main"}
Ext.define('Shopware.apps.ViisonShippingCommonIndexPopup.view.Window', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison-shipping-commmon-index-popup-window',
    border: false,
    autoShow: true,
    width: 620,
    height: '90%',
    layout: 'border',
    snippets: {
        toolbar: {
            hideDialogInTheFuture: '{s name="window/toolbar/hide_dialog_in_the_future"}{/s}',
            okButton: '{s name="window/toolbar/ok_button"}{/s}'
        }
    },

    /**
     * @Override
     */
    initComponent: function() {
        // Create docked toolbar
        this.hideDialogInTheFutureCheckbox = Ext.create('Ext.form.field.Checkbox', {
            xtype: 'checkbox',
            name: 'hideDialogInTheFuture',
            value: false,
            uncheckedValue: false,
            inputValue: true,
            labelWidth: 220,
            labelSeparator: '',
            hideLabel: true,
            boxLabel: this.snippets.toolbar.hideDialogInTheFuture,
            fieldLabel: this.snippets.toolbar.hideDialogInTheFuture
        });
        var okButton = Ext.create('Ext.button.Button', {
            text: this.snippets.toolbar.okButton,
            cls: 'primary',
            action: 'closeWindow',
            scope: this,
            handler: function() {
                this.fireEvent('closeWindow', this);
            }
        });
        this.dockedItems = [
            Ext.create('Ext.toolbar.Toolbar', {
                dock: 'bottom',
                ui: 'shopware-ui',
                cls: 'shopware-toolbar',
                items: [
                    this.hideDialogInTheFutureCheckbox,
                    '->',
                    okButton
                ]
            })
        ];

        this.callParent(arguments);
    },

    /**
     * Updates the width of this window and centers it in its parent viewport.
     *
     * @param width
     */
    setWidth: function(width) {
        this.callParent(arguments);
        this.center();
    },

    /**
     * Replaces all view items with a new label that renders the given HTML.
     *
     * @param html
     */
    setContentHTML: function(html) {
        this.removeAll();
        this.add(Ext.create('Ext.form.Label', {
            region: 'north',
            html: html,
            style: {
                whiteSpace: 'normal',
                height: '100%',
                overflowY: 'auto'
            }
        }));
    },

    /**
     * Replaces all view items with a new iframe that loads the given URL.
     *
     * @param url
     */
    setContentURL: function(url) {
        var me = this;

        // We need to send an ajax request instead of just setting iframe src = url in order to transmit
        // the shopware CSRF header. An iframe is used instead of e.g. a div with innerHTML to get a clean
        // separate DOM without need to reset shopware's CSS rules:
        Ext.Ajax.request({
            url: url,
            success: function(response) {
                me.removeAll();
                me.add(Ext.create('Ext.Component', {
                    region: 'north',
                    autoEl: {
                        tag: 'iframe',
                        src: 'data:text/html;charset=utf-8,' + encodeURI(response.responseText)
                    }
                }));
            }
        });
    }

});
