// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * Extend the default List controller to handle the batch label creation.
 */
//{namespace name="backend/viison_shipping_common_order/order"}
Ext.define('Shopware.apps.ViisonShippingCommonOrder.controller.List', {

    /**
     * Override the default list controller or at least parts of it.
     */
    override: 'Shopware.apps.Order.controller.List',

    /**
     * Add our custom controller
     */
    init: function() {
        this.callParent(arguments);

        // adds the list dispatch controller to the sub-application if it has not been added yet
        this.subApplication.getController('Shopware.apps.ViisonShippingCommonOrder.controller.ListDispatch');
    }

});
