// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

//{namespace name="backend/viison_shipping_common_order/order"}
Ext.define('Shopware.apps.ViisonShippingCommonOrder.controller.ListDispatchActions', {

    extend: 'Ext.app.Controller',

    /**
     * Creates an URL to the dispatch service provider tracking page including the given tracking codes string.
     * Finally opens this URL in a new browser tab/window.
     *
     * @param labels A list containing all labels.
     */
    openTrackingWindow: function(labels) {
        var me = this;
        var trackingCodesArray = [];

        Ext.each(labels, function(label) {
            trackingCodesArray.push(label.get('trackingCode'));
        });

        var trackingCodes = trackingCodesArray.join(me.trackingNumberDelimiter);

        // Create URL
        var url = me.trackingURL + trackingCodes;

        // Open tracking URL in new window
        window.open(url, '_blank');
    },
    
    additionalSetupForTrackingUrl: function (label) {

    }

});
