// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * We override the order detail controller to be able to intervene the default
 * behaviour when the pencil icon in the order list view is clicked to edit
 * individual orders. For each dispatch service provider plugin, a new controller
 * is added that is responsible for the respective tab in the order detail window.
 */
//{namespace name="backend/viison_shipping_common_order/order"}
Ext.define('Shopware.apps.ViisonShippingCommonOrder.controller.Main', {

    /**
     * Override the default order details controller or at least parts of it.
     */
    override: 'Shopware.apps.Order.controller.Main',

    /**
     * Override init method to add a tabpanel listener. If the application has
     * been launched with an additional parameter 'focus', the selected tab
     * will be opened.
     */
    init: function() {
        var me = this;
        me.control({
            'order-detail-window tabpanel': {
                'render': function(tabpanel) {
                    if (me.subApplication.params && me.subApplication.params.focus) {
                        tabpanel.setActiveTab(tabpanel.down(me.subApplication.params.focus));
                    }
                }
            }
        });
        this.callParent(arguments);
    },

    /**
     * Add a new dispatch service provider tab controller to this sub-application.
     *
     * @param tabControllerClass string
     */
    addDispatchServiceProviderTabControllerClass: function(tabControllerClass) {
        this.dispatchServiceProviderControllers = this.dispatchServiceProviderControllers || [];
        this.dispatchServiceProviderControllers.push(this.subApplication.getController(tabControllerClass));
    },

    /**
     * Overridden event listener method that is executed when the default edit button
     * has been clicked. We let the dispatch service provider controllers react to this
     * event before the order detail window is opened.
     *
     * @param record The record whose details should be opened.
     */
    showOrder: function(record) {
        Ext.each(this.dispatchServiceProviderControllers, function(tabController) {
            tabController.onShowOrder(record);
        });
        this.callParent(arguments);
    }

});
