// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The model representing a single BatchLabelStatus storing all information about
 * a single createLabel request and its response.
 */
Ext.define('Shopware.apps.ViisonShippingCommonOrder.model.BatchLabelStatus', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Model',

    /**
     * The fields used for this model.
     */
    fields: [
        { name: 'id', type: 'int' },
        { name: 'labelId', type: 'int' },
        { name: 'orderId', type: 'int' },
        { name: 'orderNumber', type: 'string' },
        { name: 'trackingCode', type: 'string' },
        { name: 'success', type: 'boolean', defaultValue: true },
        { name: 'message', type: 'string' },
        { name: 'warningMessage', type: 'string', defaultValue: '' }
    ],

    /**
     * Associate each status with its corresponding ShippingLabel.
     */
    associations: [
        {
            type: 'hasOne',
            model: 'Shopware.apps.ViisonShippingCommonOrder.model.ShippingLabel',
            foreignKey: 'labelId',
            setterName: 'setLabel'
        }
    ]

});
