// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The model representing a single ShippingLabel as well as additional information
 * used to create one. This is necessary, because its not possible to add custom
 * parameters to a save() call.
 */
Ext.define('Shopware.apps.ViisonShippingCommonOrder.model.ShippingLabel', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Model',

    /**
     * The fields used for this model.
     */
    fields: [
        { name: 'id', type: 'int' },
        { name: 'orderId', type: 'int', useNull: true },
        { name: 'trackingCode', type: 'string' },
        { name: 'url', type: 'string' },
        { name: 'created', type: 'string' },
        { name: 'exportDocumentUrl', type: 'string' },
        { name: 'customerAddress', type: 'string' },
        { name: 'returnShipment', type: 'boolean', defaultValue: false },
        { name: 'shippingLabelId', type: 'int', defaultValue: null},
        { name: 'warningMessageForCashOnDelivery', type: 'string', defaultValue: '' },
        // New shipment document fields
        { name: 'documents', type: 'auto', defaultValue: null },
        { name: 'entityName', type: 'string', defaultValue: null },
        // Custom address values
        { name: 'useDetails', type: 'boolean', defaultValue: true },
        { name: 'detailsSalutation', type: 'string' },
        { name: 'detailsFirstName', type: 'string' },
        { name: 'detailsLastName', type: 'string' },
        { name: 'detailsStreet', type: 'string' },
        { name: 'detailsStreetNumber', type: 'string' },
        { name: 'detailsStreetNumberBase', type: 'string' },
        { name: 'detailsStreetNumberExtension', type: 'string', useNull: false, defaultValue: '' },
        { name: 'detailsAdditionalAddressLine', type: 'string', useNull: false, defaultValue: '' },
        { name: 'detailsZipCode', type: 'string' },
        { name: 'detailsCity', type: 'string' },
        { name: 'detailsStateId', type: 'int' },
        { name: 'detailsCountryId', type: 'int' },
        { name: 'detailsCompany', type: 'string' },
        { name: 'detailsDepartment', type: 'string' },
        { name: 'detailsPhone', type: 'string' },
        { name: 'detailsEmail', type: 'string' },
        // Packaging description
        { name: 'packagingLength', type: 'int', useNull: true },
        { name: 'packagingWidth', type: 'int', useNull: true },
        { name: 'packagingHeight', type: 'int', useNull: true },
        { name: 'packagingWeight', type: 'string' },
        // Custom settings
        { name: 'settingsProduct', type: 'int' },
        { name: 'settingsCreateExportDocument', type: 'boolean', defaultValue: false },
        { name: 'settingsSaveInOrder', type: 'boolean', defaultValue: false },
        { name: 'settingsCashOnDelivery', type: 'boolean', defaultValue: false },
        // Extra settings
        { name: 'extraSettingsAmount', type: 'float', defaultValue: null, useNull: true  },
        { name: 'extraSettingsCurrency', type: 'string', defaultValue: null, useNull: true  },
        { name: 'extraSettingsInsuranceAmount', type: 'float', defaultValue: null, useNull: true },
        { name: 'extraSettingsInsuranceCurrency', type: 'string', defaultValue: null, useNull: true },
        // Additional flags
        // Error handling
        { name: 'creationSuccess', type: 'boolean', defaultValue: true },
        { name: 'message', type: 'string' },
        { name: 'errorCode', type: 'int' }
    ],

    constructor: function() {
        // configure the data communication
        this.setProxy({
            type: 'ajax',
                api: {
                    create: this.createURL,
                    destroy: this.destroyURL
                },
            reader: {
                type: 'json',
                    root: 'data',
                    totalProperty: 'total'
            }
        });

        this.callParent(arguments);
    }

});
