// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The window containing on overview about the batch label creation states.
 */
//{namespace name="backend/viison_shipping_common_order/order"}
Ext.define('Shopware.apps.ViisonShippingCommonOrder.view.BatchLabel.Window', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Enlight.app.Window',

    /**
     * List of short aliases for class names. Most useful for defining xtypes for widgets.
     */
    alias: 'widget.order-viison-shipping-common-batch-label-window',

    /**
     * An optional extra CSS class that will be added to this component's Element.
     */
    cls: Ext.baseCSSPrefix + 'order-viison-shipping-common-batch-label-window',

    /**
     * Define the window width.
     */
    width: 700,

    /**
     * Define the window height.
     */
    height: 500,

    /**
     * Display no footer button for the detail window
     */
    footerButton: false,

    /**
     * Hide minimize button.
     */
    minimizable: false,

    /**
     * Hide maximize button.
     */
    maximizable: false,

    /**
     * Fix window at its initial position on the screen.
     */
    draggable: false,

    /**
     * The unique id for this object to use for state management purposes.
     */
    stateId: 'shopware-order-viison-shipping-common-batch-label-window',

    /**
     * Set layout for this component to vbox.
     */
    layout: {
        align: 'stretch',
        type: 'vbox'
    },

    /**
     * Contains all snippets for the component.
     */
    snippets: {
        title: '{s name="batch_label/window/title"}{/s}',
        newOrderStatus: {
            label: '{s name="batch_label/window/new_order_status/label"}{/s}',
            defaultValue: '{s name="batch_label/window/new_order_status/default_value"}{/s}',
            helpText: '{s name="batch_label/window/new_order_status/help_text"}{/s}'
        },
        sendMail: {
            label: '{s name="batch_label/window/send_mail/label"}{/s}',
        },
        statusListTitle: '{s name="batch_label/window/status_list_title"}{/s}',
        buttons: {
            confirmCreation: '{s name="batch_label/window/buttons/confirm_creation"}{/s}',
            close: '{s name="batch_label/window/buttons/close"}{/s}',
            showJoinedExportDocuments: '{s name="batch_label/window/buttons/show_joined_export_documents"}{/s}',
            showJoinedLabels: '{s name="batch_label/window/buttons/show_joined_labels"}{/s}'
        },
        loadMaskMessage: '{s name="batch_label/window/loadMask"}{/s}'
    },

    /**
     * The main initializer adding view components.
     */
    initComponent: function() {
        this.title = this.snippets.title;

        // Add the status list as well as the bottom toolbar to this window
        this.items = [
            this.createTopToolbar(),
            Ext.create('Ext.panel.Panel', {
                title: this.snippets.statusListTitle,
                layout: {
                    type: 'hbox',
                    align: 'stretch'
                },
                flex: 1,
                margin: 5,
                items: [
                    this.createListPanel()
                ]
            })
        ];
        this.dockedItems = [
            this.createBottomToolbar()
        ];

        // Create a visible load mask
        this.loadMask = new Ext.LoadMask(this, {
            msg: this.snippets.loadMaskMessage
        });

        this.callParent(arguments);
    },

    /**
     * Create the list panel containing information about each order of the current batch.
     *
     * @return The created list panel.
     */
    createListPanel: function() {
        this.listPanel =  Ext.create('Shopware.apps.ViisonShippingCommonOrder.view.BatchLabel.List', {
            store: this.batchStore,
            labelStore: this.labelStore,
            flex: 1,
            border: false,
            shadow: false,
            style: {
                'background-color': 'transparent',
                'box-shadow': 'none',
                '-moz-box-shadow': 'none',
                '-webkit-box-shadow': 'none',
                '-o-box-shadow': 'none'
            }
        });

        return this.listPanel;
    },

    /**
     * Create the toolbar located at the top of the window. It contains a combobox for selecting
     * the status in which the orders, for which a new label was successfully created, will be put in.
     * Furthermore it contains a button for starting the whole batch label creation process.
     */
    createTopToolbar: function() {
        var me = this;

        // Create a combo box for selecting the new order status
        this.statusSelectionBox = Ext.create('Ext.form.field.ComboBox', {
            queryMode: 'local',
            store: me.orderStatusStore,
            displayField: 'description',
            valueField: 'id',
            fieldLabel: me.snippets.newOrderStatus.label,
            labelWidth: 160,
            helpText: me.snippets.newOrderStatus.helpText,
            autoSelect: true
        });

        // Add the default 'no changes' value to the combobox
        this.statusSelectionBox.getStore().insert(0, {
            id: 100,
            description: me.snippets.newOrderStatus.defaultValue
        });
        // Select the 'no changes' value
        this.statusSelectionBox.setValue(100);

        this.sendMailCheckbox = Ext.create('Ext.form.field.Checkbox', {
            xtype: 'checkbox',
            value: false,
            uncheckedValue: false,
            inputValue: true,
            labelWidth: 160,
            fieldLabel: me.snippets.sendMail.label,
        });

        // Create the toolbar containing the status selection field as well as a button
        // for starting the batch creation
        return Ext.create('Ext.toolbar.Toolbar', {
            dock: 'top',
            ui: 'shopware-ui',
            margin: 5,
            items: [
                {
                    xtype: 'container',
                    layout: {
                        type: 'hbox',
                        align: 'stretch',
                    },
                    items: [
                        {
                            xtype: 'container',
                            layout: {
                                type: 'vbox',
                                align: 'stretch',
                            },
                            items: [
                                this.statusSelectionBox,
                                this.sendMailCheckbox,
                            ],
                        },
                        {
                            xtype: 'tbspacer',
                            width: 50
                        },
                        {
                            xtype: 'container',
                            layout: {
                                type: 'vbox',
                                align: 'fit',
                            },
                            items: [
                                {
                                    xtype: 'button',
                                    iconCls: 'sprite-plus-circle-frame',
                                    text: me.snippets.buttons.confirmCreation,
                                    action: 'confirmBatchLabelCreation',
                                    scope: this,
                                    handler: function() {
                                        me.fireEvent('confirmBatchLabelCreation', this);
                                    }
                                }
                            ],
                        },
                    ],
                },
            ]
        });
    },

    /**
     * Creates a toolbar containing buttons for closing the window
     * as well as showing all created labels in one PDF.
     *
     * @return The created toolbar.
     */
    createBottomToolbar: function() {
        var me = this;

        // Create close button
        me.closeButton = Ext.create('Ext.button.Button', {
            cls: 'secondary',
            text: me.snippets.buttons.close,
            action: 'closeBatchStatusWindow',
            handler: function() {
                me.close();
            }
        });

        // Create button to display all labels in one PDF
        me.showJoinedLabelsButton = Ext.create('Ext.button.Button', {
            cls: 'primary',
            text: me.snippets.buttons.showJoinedLabels,
            action: 'showJoinedBatchLabels',
            handler: function() {
                me.fireEvent('showJoinedBatchLabels');
            }
        });

        // Create button to display all export documents in one PDF
        me.showJoinedExportDocumentsButton = Ext.create('Ext.button.Button', {
            cls: 'primary',
            text: me.snippets.buttons.showJoinedExportDocuments,
            action: 'showJoinedExportDocuments',
            handler: function() {
                me.fireEvent('showJoinedExportDocuments');
            }
        });

        // Create toolbar and add button
        return Ext.create('Ext.toolbar.Toolbar', {
            dock: 'bottom',
            ui: 'footer',
            border: false,
            shadow: false,
            padding: '5 0 5 0',
            style: {
                'background-color': 'transparent',
                'box-shadow': 'none',
                '-moz-box-shadow': 'none',
                '-webkit-box-shadow': 'none',
                '-o-box-shadow': 'none'
            },
            items: [
                '->',
                me.closeButton,
                me.showJoinedLabelsButton,
                me.showJoinedExportDocumentsButton
            ]
        });
    }

});
