// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * A form for editing the recipient, subject and content of an email.
 */
//{namespace name="backend/viison_shipping_common_order/order"}
Ext.define('Shopware.apps.ViisonShippingCommonOrder.view.detail.Mail', {

    /**
     * Extend ViisonCommonMailComposer panel but with different event.
     */
    extend: 'Shopware.apps.ViisonCommonMailComposer.view.Main',

    /**
     * List of short aliases for class names. Most useful for defining xtypes for widgets.
     */
    alias: 'widget.order-viison-shipping-common-mail',

    createToolbarItems: function() {
        var me = this;
        var toolbarItems = this.callParent(arguments);
        Ext.each(toolbarItems, function(item) {
            if (item.cls === 'primary') {
                item.handler = function() {
                    me.fireEvent('sendReturnLabelMail', me);
                };
            }
        });
        return toolbarItems;
    }

});
