// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default form, the CRUD methods for the product mapping are added
 * to the default save button event.
 */
//{namespace name="backend/viison_shipping_common_shipping/shipping"}
Ext.define('Shopware.apps.ViisonShippingCommonShipping.controller.DefaultForm', {

    /**
     * Override the default order details controller or at least parts of it.
     */
    override: 'Shopware.apps.Shipping.controller.DefaultForm',

    /**
     * Add a new dispatch service provider controller to this sub-application.
     *
     * @param dispatchServiceProviderControllerClass string
     */
    addDispatchServiceProviderControllerClass: function(dispatchServiceProviderControllerClass) {
        this.dispatchServiceProviderControllers = this.dispatchServiceProviderControllers || [];
        this.dispatchServiceProviderControllers.push(this.subApplication.getController(dispatchServiceProviderControllerClass));
    }

});
