// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default shipping main controller, the stores of the dispatch service provider tab
 * are created and their data is loaded. Furthermore a listener is added to the dispatch store
 * to handle removed dispatch methods and delete their product mappings, too.
 */
//{namespace name="backend/viison_shipping_common_shipping/shipping"}
Ext.define('Shopware.apps.ViisonShippingCommonShipping.controller.Main', {

    /**
     * Override the default shipping main controller or at least parts of it.
     */
    override: 'Shopware.apps.Shipping.controller.Main',

    /**
     * Adds additional event listeners.
     */
    init: function() {
        var me = this;

        // Add listener for removed records
        var dispatchStore = me.getStore('Dispatch');
        if (dispatchStore !== undefined) {
            dispatchStore.on({
                remove: { fn: me.onDispatchDeleteMapping, scope: me }
            });
        }

        me.callParent(arguments);
    },

    /**
     * Override the default method to load the product store when a record is available.
     *
     * @param record The record for which a new edit form will be created.
     * @param costsmatrix Irrelevant parameter
     * @return The result of the parent(overridden) method.
     */
    createEditForm: function(record, costsmatrix) {
        var me = this;
        Ext.each(me.dispatchServiceProviderControllers, function(tabController) {
            tabController.createEditForm(record);
        });
        return me.callParent(arguments);
    },

    /**
     * This function is called when a dispatch method is deleted. Delete product mappings for all dispatch service providers.
     *
     * @param store The store firing the event.
     * @param record The record which was removed.
     * @param index The index of the removed record.
     * @param options Additional options like the scope this listener is executed in.
     */
    // TODO: After moving to ExtJS 4.2.x this method requires 'isMove' as its fourth parameter. Options are always the last param.
    onDispatchDeleteMapping: function(store, record, index, options) {
        var me = this;
        Ext.each(me.dispatchServiceProviderControllers, function(tabController) {
            tabController.onDispatchDeleteMapping(record);
        });
    },

    /**
     * Add a new dispatch service provider tab controller to this sub-application.
     *
     * @param tabControllerClass string
     */
    addDispatchServiceProviderTabControllerClass: function(tabControllerClass) {
        var me = this;
        me.dispatchServiceProviderControllers = me.dispatchServiceProviderControllers || [];
        me.dispatchServiceProviderControllers.push(me.subApplication.getController(tabControllerClass));
    }

});
