// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The model representing a single shipping method to dispatch service provider product mapping.
 */
Ext.define('Shopware.apps.ViisonShippingCommonShipping.model.ProductMapping', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Model',

    /**
     * The fields used for this model.
     */
    fields: [
        { name: 'id', type: 'int' },
        { name: 'productId', type: 'int' },
        { name: 'dispatchId', type: 'int' },
        { name: 'exportDocumentRequired', type: 'boolean', defaultValue: false }
    ],

    constructor: function() {
        // configure the data communication
        this.setProxy({
            type: 'ajax',
            api: {
                create: this.createURL,
                update: this.updateURL,
                destroy: this.destroyURL
            },
            reader: {
                type: 'json',
                root: 'data',
                totalProperty: 'total'
            }
        });

        this.callParent(arguments);
    }

});
