// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The store handling all Product objects.
 */
Ext.define('Shopware.apps.ViisonShippingCommonShipping.store.Product', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Store',

    /**
     * Define the used model for this store.
     */
    model: 'Shopware.apps.ViisonShippingCommonShipping.model.Product',

    /**
     * Set store page size to allow grid paging.
     */
    pageSize: 10,

    /**
     * Disable auto loading.
     */
    autoLoad: false,

    constructor: function() {
        // configure the data communication
        this.setProxy({
            type: 'ajax',
            url: this.getProductsURL,
            reader: {
                type: 'json',
                root: 'data',
                totalProperty: 'total'
            }
        });

        this.callParent(arguments);
    }

});
