// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default edit panel, the additional UPS tab is created
 * and added to the main tab panel.
 */
Ext.define('Shopware.apps.ViisonShippingCommonShipping.view.edit.Panel', {

    /**
     * Override the default shipping edit panel or at least parts of it.
     */
    override: 'Shopware.apps.Shipping.view.edit.Panel',

    addDispatchServiceProviderTabClass: function(dispatchServiceProviderTabClass) {
        var me = this;
        me.dispatchServiceProviderTabClasses = me.dispatchServiceProviderTabClasses || [];
        me.dispatchServiceProviderTabClasses.push(dispatchServiceProviderTabClass);
    },

    /**
     * By overriding the default 'createTabPanel' method it adds the
     * dispatch service provider tabs to the southern tab panel.
     *
     * @return The created tab panel holding the default tabs as well as the UPS tab.
     */
    createTabPanel: function() {
        var me = this;

        // Create the main tab panel
        var tabPanel = this.callParent(arguments);

        Ext.each(me.dispatchServiceProviderTabClasses, function(dispatchServiceProviderTabClass) {

            // Add a new dispatch service provider tab to the panel
            tabPanel.add(Ext.create(dispatchServiceProviderTabClass, {
                store: me.mainStore,
                dispatchId: me.dispatchId,
                record: me.editRecord
            }));
        });

        return tabPanel;
    }

});
