// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The main container of the dispatch service provider tab which creates the main input form
 * and adds it to the view container.
 */
//{namespace name="backend/viison_shipping_common_shipping/shipping"}
Ext.define('Shopware.apps.ViisonShippingCommonShipping.view.edit.Tab', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.container.Container',

    /**
     * Defines the component layout.
     */
    layout: 'auto',

    /**
     * Add padding.
     */
    padding: 10,

    /**
     * Enable auto scrolling.
     */
    autoScroll: true,

    /**
     * Contains all snippets for the view component.
     */
    snippets: {
        title: '{s name="tab/title"}{/s}'
    },

    /* This class name can be overwritten in dispatch provider plugins to use derived versions */
    mappingPanelClass: 'Shopware.apps.ViisonShippingCommonShipping.view.edit.MappingPanel',

    /**
     * The main initializer registering events and adding view components.
     */
    initComponent: function() {
        var me = this;

        // Get stores
        me.productStore = Ext.getStore(me.productStoreId);
        me.productMappingStore = Ext.create(me.productMappingStoreClass).load();

        me.title = Ext.String.format(me.snippets.title, me.dispatchServiceProviderName);
        me.items = [
            me.createMappingForm()
        ];

        me.callParent(arguments);
    },

    /**
     * Add additional parameter, so every Adapter can add specific things
     *
     * @return Object
     */
    getAdditionalPropertiesForMappingForm: function() {
        return {};
    },

    /**
     * Creates the main dispatch service provider form.
     *
     * @return
     */
    createMappingForm: function() {
        var me = this;

        var options = {
            productStore: me.productStore,
            productMappingStore: me.productMappingStore,
            productMappingStoreClass: me.productMappingStoreClass,
            record: me.record,
            dispatchServiceProviderName: me.dispatchServiceProviderName,
            exportDocumentEnabled: me.exportDocumentEnabled
        };

        options = (me.getAdditionalPropertiesForMappingForm && me.getAdditionalPropertiesForMappingForm()) ?
            Ext.merge({
                productStore: me.productStore,
                productMappingStore: me.productMappingStore,
                productMappingStoreClass: me.productMappingStoreClass,
                record: me.record,
                dispatchServiceProviderName: me.dispatchServiceProviderName,
                exportDocumentEnabled: me.exportDocumentEnabled
        }, me.getAdditionalPropertiesForMappingForm()) : options;

        me.mappingForm = Ext.create(me.mappingPanelClass, options);

        return me.mappingForm;
    }

});
