<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Enlight\Event\SubscriberInterface;
use Shopware\Plugins\ViisonShippingCommon\Components\ViisonShippingCommonDispatchData;

class ViisonShippingCommon_Subscriber_ShippingCommon implements SubscriberInterface
{

    /**
     * @var string $shippingProviderClass
     */
    private $shippingProviderClass;

    public static function getSubscribedEvents()
    {
        return array(
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonShippingCommonConfig' => 'onGetControllerPathBackendViisonShippingCommonConfig',
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonShippingCommonFreeFormLabels' => 'onGetControllerPathBackendViisonShippingCommonFreeFormLabels',
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonShippingCommonGridLabelPrinting' => 'onGetControllerPathBackendViisonShippingCommonGridLabelPrinting',
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonShippingCommonOrder' => 'onGetControllerPathBackendViisonShippingCommonOrder',
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonShippingCommonIndexPopup' => 'onGetControllerPathBackendViisonShippingCommonIndexPopup',
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonShippingCommonMail' => 'onGetControllerPathBackendViisonShippingCommonMail',
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonShippingCommonShipping' => 'onGetControllerPathBackendViisonShippingCommonShipping',
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonShippingCommonDailyClosing' => 'onGetControllerPathBackendViisonShippingCommonDailyClosing',
            'Enlight_Bootstrap_InitResource_ViisonShippingCommonDispatchData' => 'onInitResourceViisonShippingCommonDispatchData',
            'Shopware_Plugins_ViisonPickwareMobile_CollectShippingProviders' => 'onCollectShippingProviders',
            'Shopware_Plugins_ViisonShippingCommon_CollectShippingProviders' => 'onCollectShippingProviders'
        );
    }

    /**
     * TODO: Make the parameter $shippingProviderClass non-optional, as soon as new plugin
     *         versions have greater adoption. By making it optional, the constructor is
     *         backwards compatible.
     *
     * @param string $shippingProviderClass
     */
    public function __construct($shippingProviderClass = null)
    {
        $this->shippingProviderClass = $shippingProviderClass;
    }

    /**
     * Includes the ViisonShippingCommonConfig controller.
     *
     * @param Enlight_Event_EventArgs $args The event parameters.
     * @return string The path of the controller.
     */
    public function onGetControllerPathBackendViisonShippingCommonConfig(Enlight_Event_EventArgs $args)
    {
        // Add snippet directory
        Shopware()->Snippets()->addConfigDir(__DIR__ . '/../../Snippets/');

        // Register template directory
        Shopware()->Template()->addTemplateDir(
            __DIR__ . '/../../Views/'
        );

        return __DIR__ . '/../Controllers/ViisonShippingCommonConfig.php';
    }

    /**
     * Includes the ViisonShippingCommonFreeFormLabels controller.
     *
     * @param Enlight_Event_EventArgs $args The event parameters.
     * @return string The path of the controller.
     */
    public function onGetControllerPathBackendViisonShippingCommonFreeFormLabels(Enlight_Event_EventArgs $args)
    {
        // Add snippet directory
        Shopware()->Snippets()->addConfigDir(__DIR__ . '/../../Snippets/');

        // Register template directory
        Shopware()->Template()->addTemplateDir(
            __DIR__ . '/../../Views/'
        );

        return __DIR__ . '/../Controllers/ViisonShippingCommonFreeFormLabels.php';
    }

    /**
     * Includes the ViisonShippingCommonGridLabelPrinting controller.
     *
     * @param Enlight_Event_EventArgs $args The event parameters.
     * @return string The path of the controller.
     */
    public function onGetControllerPathBackendViisonShippingCommonGridLabelPrinting(Enlight_Event_EventArgs $args)
    {
        // Add snippet directory
        Shopware()->Snippets()->addConfigDir(__DIR__ . '/../../Snippets/');

        // Register template directory
        Shopware()->Template()->addTemplateDir(
            __DIR__ . '/../../Views/'
        );

        return __DIR__ . '/../Controllers/ViisonShippingCommonGridLabelPrinting.php';
    }

    /**
     * Includes the ViisonShippingCommonOrder controller.
     *
     * @param Enlight_Event_EventArgs $args The event parameters.
     * @return string The path of the controller.
     */
    public function onGetControllerPathBackendViisonShippingCommonOrder(Enlight_Event_EventArgs $args)
    {
        // Add snippet directory
        Shopware()->Snippets()->addConfigDir(__DIR__ . '/../../Snippets/');

        // Register template directory
        Shopware()->Template()->addTemplateDir(
            __DIR__ . '/../../Views/'
        );

        return __DIR__ . '/../Controllers/ViisonShippingCommonOrder.php';
    }

    /**
     * Includes the ViisonShippingCommonShipping controller.
     *
     * @param Enlight_Event_EventArgs $args The event parameters.
     * @return string The path of the controller.
     */
    public function onGetControllerPathBackendViisonShippingCommonShipping(Enlight_Event_EventArgs $args)
    {
        Shopware()->Snippets()->addConfigDir(__DIR__ . '/../../Snippets/');

        // Register template directory
        Shopware()->Template()->addTemplateDir(
            __DIR__.'/../Views/'
        );

        return __DIR__ . '/../Controllers/ViisonShippingCommonShipping.php';
    }

    /**
     * Includes the ViisonShippingCommonDailyClosing controller.
     *
     * @param \Enlight_Event_EventArgs $args The event parameters.
     * @return string The path of the controller.
     */
    public function onGetControllerPathBackendViisonShippingCommonDailyClosing(\Enlight_Event_EventArgs $args)
    {
        Shopware()->Snippets()->addConfigDir(__DIR__ . '/../../Snippets/');

        // Register template directory
        Shopware()->Template()->addTemplateDir(
            __DIR__.'/../Views/'
        );

        return __DIR__ . '/../Controllers/ViisonShippingCommonDailyClosing.php';
    }

    /**
     * Creates the ViisonShippingCommonDispatchData component.
     * @return ViisonShippingCommonDispatchData
     */
    public function onInitResourceViisonShippingCommonDispatchData()
    {
        return new ViisonShippingCommonDispatchData();
    }

    /**
     * Creates and returns a new shipping provider instance.
     *
     * @param \Enlight_Event_EventArgs $args
     * @return \ViisonShippingCommon_Classes_ShippingProvider
     */
    public function onCollectShippingProviders(\Enlight_Event_EventArgs $args)
    {
        return ($this->shippingProviderClass) ? new $this->shippingProviderClass() : null;
    }
}
