<?php
/*
 * Copyright (c) Pickware GmbH. All rights reserved.
 * This file is part of software that is released under a proprietary license.
 * You must not copy, modify, distribute, make publicly available, or execute
 * its contents or parts thereof without express permission by the copyright
 * holder, unless otherwise permitted by law.
 */

use Shopware\Plugins\ViisonCommon\Classes\Util\Util as ViisonCommonUtil;

// Goutte v2 requires guzzle v4-6 and some symfony v2 components which are not required in Shopware <= 5.7.
// Goutte v4 does not require guzzle anymore, but requires some symfony v4.4 components, which are not required in
// Shopware <= 5.7 as well. In addition Goutte v4 requires at least php 7.1.3.
if (ViisonCommonUtil::assertMinimumShopwareVersion('5.7.0')) {
    require_once(__DIR__ . '/goutte-v4/vendor/autoload.php');
} else {
    require_once(__DIR__ . '/goutte-v2/vendor/autoload.php');
}
