<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Classes;

/**
 * Class FileRemover
 * @package Shopware\Plugins\ViisonSetArticles\Classes
 */
class FileRemover
{

    private $targetDir = null;

    public function __construct($trgt)
    {
        $this->targetDir = $trgt;
    }

    /**
     * Initiliazes remove function
     * @return bool
     */
    public function remove()
    {
        return $this->recurseRemove($this->targetDir);
    }

    /**
     * Removes all files and folders recursively from one destination folder.
     *
     * @param $dest
     * @return bool
     */
    private function recurseRemove($dest)
    {
        $result = true;
        if (is_dir($dest)) {
            $objects = scandir($dest);
            foreach ($objects as $object) {
                if ($object != '.' && $object != '..') {
                    if (is_dir($dest . '/' . $object)) {
                        $result = $result && $this->recurseRemove($dest . '/' . $object);
                    } else {
                        $result = $result && unlink($dest . '/' . $object);
                    }
                }
            }

            return $result && rmdir($dest);
        }
    }
}
