<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

require_once  __DIR__ . '/../../ViisonSetArticles/ViisonSetArticlesUtil.php';

/**
 * Magnalister - SetArticles
 * REMARK: DO NOT REMOVE THIS HEADLINE! It is checked upon compatibility check
 * @Shopware\noEncryption
 */

/**
 * In this code we add sub articles to the incoming order and set our custom attributes
 */

$pushIndices = 0;
$products = $aOrder['Products'];
foreach ($aOrder['Products'] as $key => &$product) {
    $util = new ViisonSetArticlesUtil();
    // Checks if the SetArticles plugin is installed and active
    if (!$util->isSetArticlesInstalledAndActive()) {
        break;
    }

    $ordernumber = $product['SKU'];
    $articleDetail = Shopware()->Container()->get('models')->getRepository('Shopware\\Models\\Article\\Detail')->findOneBy([
        'number' => $ordernumber,
    ]);

    if ($articleDetail && $articleDetail->getAttribute() && $articleDetail->getAttribute()->getViisonSetarticleActive()) {
        /*
         * Add custom attributes to set article (and sub article down below) not to the article data array and persist
         * them later on in the DB (see viisonFixOrderDetailAttributes in Util).
         *
         * Remark: we cannot use and set the actual set article OrderDetailID (which we normally would) since the order
         * was not persisted as a Shopware order yet. Use viisonSetArticleArticleOrdernumber instead and fix that up
         * later.
         */
        $products[$key + $pushIndices]['viisonSetArticleArticleOrdernumber'] = $ordernumber;

        // Fetch all sub articles for a given set article
        $subArticles = Shopware()->Container()->get('models')->getRepository('Shopware\\CustomModels\\ViisonSetArticles\\SetArticle')->findBy([
            'setId' => $articleDetail->getId(),
        ]);

        foreach ($subArticles as $subArticle) {
            $newProduct = [
                'SKU' => $subArticle->getArticleDetail()->getNumber(),
                /*
                 * Remark: SetArticle-Prefix is not translated since we do not pass a shop here.
                 * Maybe improve this in the future
                 */
                'ItemTitle' => $subArticle->getSubArticleName(),
                'Price' => '0.00',
                'Quantity' => $subArticle->getQuantity() * $product['Quantity'],
                'Tax' => $product['Tax'], // Use set article tax
                'StockSync' => $product['StockSync'],
                // Also add custom attribute to sub article
                'viisonSetArticleArticleOrdernumber' => $ordernumber,
            ];

            // Remark: nest $newProduct inside new array, otherwise array_splice would add $newProducts different items
            // instead of the array itself
            array_splice($products, $key + $pushIndices + 1, 0, [$newProduct]);
            $pushIndices++;
        }
    } else {
        $products[$key + $pushIndices]['viisonSetArticleArticleOrdernumber'] = null;
    }
}
$aOrder['Products'] = $products;
