<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

require_once  __DIR__ . '/../ViisonSetArticlesUtil.php';

MLFilesystem::gi()->loadClass('Shopware_Model_Order');

/**
 * Class ML_ViisonSetArticles_Model_Order
 * @Shopware\noEncryption
 */
// @codingStandardsIgnoreLine
class ML_ViisonSetArticles_Model_Order extends ML_Shopware_Model_Order
{

    /**
     * We modify the creation of ShopwareOrders by MagnalisterOrderData by persisting the custom attributes
     * of each Product that has been that we set earlier in the addOrder hook.
     *
     * @param array $aData
     * @return array mixed
     */
    public function shopOrderByMagnaOrderData($aData)
    {
        /**
         * After this call the shopware Order has been placed and created.
         * We can now add our custom attributes to the Order and its Details
         */
        $mReturn = parent::shopOrderByMagnaOrderData($aData);

        $util = new ViisonSetArticlesUtil();
        // Checks if the SetArticles plugin is installed and active
        if ($util->isSetArticlesInstalledAndActive()) {
            $magnalisterSetArticleOrderDetailAssociationService = Shopware()->Container()->get('viison_set_articles.magnalister_set_article_order_detail_association_service');
            $magnalisterSetArticleOrderDetailAssociationService->associateSetArticleOrderDetails(
                $mReturn['ShopwareOrderNumber'],
                $mReturn['Products']
            );
        }

        return $mReturn;
    }
}
