<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use \Shopware\Plugins\ViisonCommon\Classes\Util\Util as ViisonCommon;

/**
 * Class ViisonSetArticlesUtil
 * @Shopware\noEncryption
 */
// @codingStandardsIgnoreLine
class ViisonSetArticlesUtil
{
    /**
     * Checks if Core - ViisonSetArticles is installed and active.
     * This check is needed so no hook logic is executed if set articles should not be active.
     * @return bool
     */
    public function isSetArticlesInstalledAndActive()
    {
        if (class_exists('Shopware\\Plugins\\ViisonCommon\\Classes\\Util\\Util')) {
            $viisonCommonUtil = new ViisonCommon();

            return $viisonCommonUtil->isPluginInstalledAndActive('Core', 'ViisonSetArticles', '1.1.0');
        }

        return false;
    }
}
