<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Components;

use Shopware\Components\Model\ModelManager;
use Shopware\Models\Order\Order;
use Shopware\Plugins\ViisonSetArticles\Components\SetArticleOrderDetailAssociation\SetArticleOrderDetailAssociationDescription;

class MagnalisterSetArticleOrderDetailAssociationService
{
    /**
     * @var ModelManager $entityManager
     */
    protected $entityManager;

    /**
     * @var SetArticleOrderDetailAssociationService $setArticleOrderDetailAssociationService
     */
    protected $setArticleOrderDetailAssociationService;

    public function __construct(
        ModelManager $entityManager,
        SetArticleOrderDetailAssociationService $setArticleOrderDetailAssociationService
    ) {
        $this->entityManager = $entityManager;
        $this->setArticleOrderDetailAssociationService = $setArticleOrderDetailAssociationService;
    }

    /**
     * Assigns the OrderDetail attribute ViisonSetArticleOrderId to set- and sub articles in a Magnalister imported
     * order. We need to enrich the order detail information (add order detail id) before we can use the
     * SetArticleOrderDetailAssociationService.
     *
     * @param string $orderNumber
     * @param array $products
     */
    public function associateSetArticleOrderDetails($orderNumber, array $products)
    {
        /** @var Order $order */
        $order = $this->entityManager->getRepository('Shopware\\Models\\Order\\Order')->findOneBy([
            'number' => $orderNumber,
        ]);
        if (!$order) {
            return;
        }

        // Find the respective Shopware order details for each of the "products" that is returned by the Magnalister
        // order creation to get the order detail id. Afterwards remove null values (no order detail could be found)
        // from the array.
        $setArticlePositionRelations = [];
        foreach ($products as $product) {
            // Also pass article name: sub articles names will contain the article order number of their set article.
            // This condition is needed when identifying sub articles that are part of multiple set articles and in the
            // same order.
            $orderDetail = $this->entityManager->getRepository('Shopware\\Models\\Order\\Detail')->findOneBy([
                'number' => $orderNumber,
                'articleNumber' => $product['SKU'],
                'articleName' => $product['ItemTitle'],
            ]);
            if ($orderDetail) {
                $setArticlePositionRelations[] = new SetArticleOrderDetailAssociationDescription(
                    $orderDetail->getId(),
                    $product['viisonSetArticleArticleOrdernumber']
                );
            }
        }

        $this->setArticleOrderDetailAssociationService->associateSetArticleOrderDetails($order, $setArticlePositionRelations);
    }
}
