<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Components;

use Enlight_Config;

class PluginConfigService
{
    const NEVER_SHOW_SUB_ARTICLES_ON_DOCUMENTS = 0;
    const ALWAYS_SHOW_SUB_ARTICLES_ON_DOCUMENTS = 1;
    const ONLY_SHOW_SUB_ARTICLES_ON_PARTIAL_DELIVERY_NOTES = 2;

    /**
     * @var Enlight_Config
     */
    private $rawPluginConfig;

    /**
     * @param Enlight_Config $rawPluginConfig
     */
    public function __construct(Enlight_Config $rawPluginConfig)
    {
        $this->rawPluginConfig = $rawPluginConfig;
    }

    /**
     * @return int
     */
    public function getDisplaySubArticlesOnDocuments()
    {
        return (int) $this->rawPluginConfig->get('displaySubArticlesOnDocuments');
    }
}
