<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Components\SetArticleOrderDetailAssociation;

/**
 * Helper class to describe the relation from a set article position (sub or set article) to their respective set
 * article order detail.
 */
class SetArticleOrderDetailAssociationDescription
{
    /**
     * Order detail id of a set or sub article that is about to be associated to their respective set article (parent).
     *
     * @var int
     */
    private $orderDetailId;

    /**
     * Article number of the set article (parent) with whom the set or sub article (this $orderDetailId) should be
     * associated.
     *
     * @var string
     */
    private $setArticleNumber;

    /**
     * @param int $orderDetailId
     * @param string $setArticleNumber
     */
    public function __construct($orderDetailId, $setArticleNumber)
    {
        $this->orderDetailId = $orderDetailId;
        $this->setArticleNumber = $setArticleNumber;
    }

    /**
     * @return int
     */
    public function getOrderDetailId()
    {
        return $this->orderDetailId;
    }

    /**
     * @return string
     */
    public function getSetArticleNumber()
    {
        return $this->setArticleNumber;
    }
}
