<?php
namespace Shopware\Plugins\ViisonSetArticles\Subscribers\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

/**
 * @copyright Copyright (c) 2018 VIISON GmbH
 */
class CommonSubscriber extends Base
{
    /**
     * Returns an array of event names this subscriber wants to listen to.
     *
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Action_PostDispatch_Backend_Index' => 'onPostDispatchBackend',
        ];
    }

    /**
     * Adds the plugin's html header block (styles) to the backends base html.
     *
     * @param \Enlight_Event_EventArgs $args
     * @return void
     */
    public function onPostDispatchBackend(\Enlight_Event_EventArgs $args)
    {
        $view = $args->getSubject()->View();
        $view->addTemplateDir($this->getPluginPath() . '/Views/');
        $view->extendsTemplate(
            'backend/base/viison_set_articles/header.tpl'
        );
    }
}
