<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Subscribers\Components;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\TemplateMailComponent as ViisonCommonTemplateMailComponentSubscriber;
use Shopware\Plugins\ViisonSetArticles\Components\PluginConfigService;

class TemplateMailComponentSubscriber extends ViisonCommonTemplateMailComponentSubscriber
{
    /**
     * @inheritdoc
     */
    public function handleBeforeCreateMail($mailModelName, \Enlight_Hook_HookArgs $args)
    {
        /** @var PluginConfigService $pluginConfigService */
        $pluginConfigService = $this->get('viison_set_articles.plugin_config');
        $hideSubArticles = $pluginConfigService->getDisplaySubArticlesOnDocuments() !== PluginConfigService::ALWAYS_SHOW_SUB_ARTICLES_ON_DOCUMENTS;
        if ($mailModelName === 'sARTICLECOMMENT' && $hideSubArticles) {
            $this->handleArticleCommentMail($args);
        }
    }

    /**
     * Removes sub articles from sARTICLECOMMENT mail (customer reminder to rate articles)
     *
     * @param \Enlight_Hook_HookArgs $args
     */
    private function handleArticleCommentMail(\Enlight_Hook_HookArgs $args)
    {
        $context = $args->getContext();
        $articles = $context['sArticles'];

        /**
         * Remark: since sub articles can be sold separately as normal articles we cannot just check if
         * an article is a sub article "somewhere" (check table in db), but rather check if it is a sub article
         * in this specific case. Therefore we check the article name. TODO: maybe improve this in the future.
         * I made it more specific to match "[prefix] [set article Ordnumber]" in case a regular has the prefix in its
         * name by accident.
         */
        $namespace = Shopware()->Container()->get('snippets')->getNamespace('backend/viison_set_articles/main');
        $subArticlePrefix = $namespace->get('subarticlePrefix', 'SetArticle:');
        $ordernumbers = array_column($articles, 'articleordernumber');

        foreach ($articles as $key => $article) {
            $foundMatch = false;
            // Try every possible prefixes (with ordernumbers from this specific order)
            foreach ($ordernumbers as $ordernumber) {
                $specificPrefix = $subArticlePrefix . ' ' . $ordernumber;
                if (mb_substr($article['name'], 0, mb_strlen($specificPrefix)) === $specificPrefix) {
                    $foundMatch = true;
                }
            }
            if ($foundMatch) {
                unset($articles[$key]);
            }
        }

        $context['sArticles'] = $articles;
        $args->setContext($context);
    }
}
