<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Subscribers\Extension;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

/**
 * Loads Article and Order Attributes JS extension (e.g. backend/viison_set_articles/article/article_attributes.js)
 * for Backend->Article/Order->Detail view to make it available outside the attribute fields.
 * Also adds custom css for Order/Detail/Position tab.
 */
class BackendSubscriber extends Base
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Action_PostDispatchSecure_Backend_Article' => 'onPostDispatchSecureArticle',
            'Enlight_Controller_Action_PostDispatchSecure_Backend_Order' => 'onPostDispatchSecureOrder',
        ];
    }

    /**
     * Adds the customisations of the article app upon loading.
     *
     * @param \Enlight_Event_EventArgs $args The arguments passed by the method triggering the event.
     */
    public function onPostDispatchSecureArticle(\Enlight_Event_EventArgs $args)
    {
        if ($args->getRequest()->getActionName() === 'load') {
            $view = $args->getSubject()->View();
            $view->extendsTemplate('backend/viison_set_articles/article/article_attributes.js');
        }
    }

    /**
     * Adds the customisations of the order app upon loading.
     *
     * @param \Enlight_Event_EventArgs $args The arguments passed by the method triggering the event.
     */
    public function onPostDispatchSecureOrder(\Enlight_Event_EventArgs $args)
    {
        if ($args->getRequest()->getActionName() === 'load') {
            $view = $args->getSubject()->View();
            $view->extendsTemplate('backend/viison_set_articles/order/position.js');
        }
    }
}
