<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Subscribers\Frontend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class StorytellingSubscriber extends Base
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Controllers_Widgets_SwagEmotionAdvanced::indexAction::after' => 'onIndexSwagEmotionAdvanced',
        ];
    }

    /**
     * Manipulate Article information of set articles in SwagEmotionAdvanced views. (Storytelling in shop frontend)
     *
     * Remark: Since this plugin is only available for SW5.0+, we do not need to consider SW4.3
     *
     * @param \Enlight_Hook_HookArgs $args
     */
    public function onIndexSwagEmotionAdvanced(\Enlight_Hook_HookArgs $args)
    {
        $article = $args->getSubject()->View()->sArticle;

        if ($article['viison_setarticle_active'] == 1) {
            $details = $this->get('models')->getRepository('Shopware\\CustomModels\\ViisonSetArticles\\SetArticle')
                ->getCombinedSetArticleDetailsData($article['articleDetailsID'], $article['minpurchase']);
            $article['instock'] = $details['instock'];
            $article['shippingtime'] = $details['shippingtime'];
            $article['isAvailable'] = $details['available'];
            $article['maxpurchase'] = $details['maxpurchase'];
            $article['weight'] = $details['weight'];
        }

        $args->getSubject()->View()->sArticle = $article;
    }
}
