<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Subscribers\PluginIntegration;

use Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagImportExport\SwagImportExportVersion2DbAdapterAdapter;
use Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagImportExport\SwagImportExportVersion3DbAdapterAdapter;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractSwagImportExportIntegrationSubscriber;
use Shopware\Plugins\ViisonSetArticles\Components\SwagImportExportIntegration\DbAdapters\ViisonSetArticlesCompositionsDbAdapter;
use Shopware_Components_Plugin_Bootstrap;

class SwagImportExportIntegrationSubscriber extends AbstractSwagImportExportIntegrationSubscriber
{
    const PROFILE_NAMES = [
        'viison_set_articles_compositions' => 'ViisonSetArticlesCompositions',
    ];

    /**
     * @param Shopware_Components_Plugin_Bootstrap $pluginBootstrap
     */
    public function __construct(Shopware_Components_Plugin_Bootstrap $pluginBootstrap)
    {
        parent::__construct(
            $pluginBootstrap,
            self::PROFILE_NAMES,
            'backend/plugins/swag_import_export/',
            $pluginBootstrap->Path() . 'Components/SwagImportExportIntegration/Profiles/'
        );
    }

    /**
     * @inheritdoc
     */
    protected function createDbAdapterOfType($adapterType)
    {
        // This plugin only handles the 'ViisonSetArticlesCompositions' adapter
        if ($adapterType !== 'ViisonSetArticlesCompositions') {
            return null;
        }
        $adapter = new ViisonSetArticlesCompositionsDbAdapter(
            $this->get('config'),
            $this->get('models'),
            $this->get('snippets')
        );

        // Note that the interface class changed in SwagImportExport plugin version 2.x to 3.0.0.
        if (interface_exists('Shopware\\Components\\SwagImportExport\\DbAdapters\\DataDbAdapter')) {
            return new SwagImportExportVersion2DbAdapterAdapter($adapter);
        }

        return new SwagImportExportVersion3DbAdapterAdapter($adapter);
    }
}
