<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Subscribers;

use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Services as CommonServicesSubscriber;
use Shopware\Plugins\ViisonSetArticles\Components\BasketService;
use Shopware\Plugins\ViisonSetArticles\Components\DocumentManipulationService;
use Shopware\Plugins\ViisonSetArticles\Components\MagnalisterSetArticleOrderDetailAssociationService;
use Shopware\Plugins\ViisonSetArticles\Components\PluginConfigService;
use Shopware\Plugins\ViisonSetArticles\Components\SetArticleOrderDetailAssociationService;

class ServicesSubscriber extends CommonServicesSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getServices()
    {
        return [
            'viison_set_articles.document_manipulation_service' => function (Container $container) {
                return new DocumentManipulationService(
                    $container->get('models'),
                    $container->get('viison_set_articles.plugin_config')
                );
            },
            'viison_set_articles.magnalister_set_article_order_detail_association_service' => function (Container $container) {
                return new MagnalisterSetArticleOrderDetailAssociationService(
                    $container->get('models'),
                    $container->get('viison_set_articles.set_article_order_detail_association_service')
                );
            },
            'viison_set_articles.plugin_config' => function (Container $container, \Enlight_Config $pluginConfig) {
                return new PluginConfigService(
                    $pluginConfig
                );
            },
            'viison_set_articles.set_article_order_detail_association_service' => function (Container $container) {
                return new SetArticleOrderDetailAssociationService(
                    $container->get('models')
                );
            },
            'viison_set_articles.basket_service' => function (Container $container) {
                return new BasketService(
                    $container->get('models')
                );
            },
        ];
    }
}
