<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Subscribers;

use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\AbstractSubApplicationRegistrationSubscriber;

class SubApplicationRegistrationSubscriber extends AbstractSubApplicationRegistrationSubscriber
{
    /**
     * @inheritdoc
     */
    public function createSubApplications()
    {
        $this->addSubApplicationExtension('ViisonSetArticlesArticleCheckbox')->extendingSubApplication('Article');
        $this->addSubApplicationExtension('ViisonSetArticlesArticleSetArticlesTab')
            ->extendingSubApplication('Article')
            ->requiringSubApplications([
                'ViisonCommonCurrencyFormatter',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplicationExtension('ViisonSetArticlesArticleSettingsFields')->extendingSubApplication('Article');
        $this->addSubApplicationExtension('ViisonSetArticlesOrderPosition')->extendingSubApplication('Order');
        $this->addSubApplicationExtension('ViisonSetArticlesShipping')->extendingSubApplication('Shipping');
    }
}
