<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonSetArticles\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class ThemeSubscriber extends Base
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Action_PostDispatchSecure' => 'onSecurePostDispatch',
            'Theme_Inheritance_Template_Directories_Collected' => 'filterThemeInheritanceTemplateDirectories',
        ];
    }

    /**
     * Appends the path to this plugin's views to the list of directories used for
     * template inheritance. in Shopware < 5.
     *
     * @param \Enlight_Event_EventArgs $args The arguments passed by the method triggering the event.
     */
    public function onSecurePostDispatch(\Enlight_Event_EventArgs $args)
    {
        $this->getPluginBootstrap()->get('template')->addTemplateDir(
            $this->getPluginPath() . 'Views/',
            'viisonSetArticles'
        );
    }

    /**
     * Appends the path to this plugin's views to the list of directories used for
     *
     * @param \Enlight_Event_EventArgs $args The arguments passed by the method triggering the event.
     * @return array
     */
    public function filterThemeInheritanceTemplateDirectories(\Enlight_Event_EventArgs $args)
    {
        $templateDirectories = $args->getReturn();
        $templateDirectories[] = $this->getPluginPath() . 'Views/';

        return $templateDirectories;
    }
}
