// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesArticle.controller.Detail', {

    override: 'Shopware.apps.Article.controller.Detail',

    /**
     * @Override
     */
    reconfigureAssociationComponents: function (article) {
        this.callParent(arguments);

        var setArticlesTab = this.getMainWindow().down('viison_set_articles_article-view-detail-tab');
        this.viisonSetArticlesUpdateStore(setArticlesTab, article.get('id'));

        if (article.getMainDetail().first().get('viisonSetarticleActive')) {
            setArticlesTab.ownerCt.setDisabled(false);
        }
    },

    /**
     * Load articleVariantStore to display the variant in the setArticlesTab after article has been saved.
     *
     * @param Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.view.detail.Tab setArticlesTab
     * @param int id
     */
    viisonSetArticlesUpdateStore: function (setArticlesTab, id) {
        if (!Ext.isDefined(setArticlesTab.articleVariantStore)) {
            return;
        }
        setArticlesTab.articleVariantStore.getProxy().extraParams = { articleId: id };
        setArticlesTab.articleVariantStore.load({
            scope: setArticlesTab,
            callback: function (records) {
                if (records.length > 0) {
                    var recordSelected = setArticlesTab.articleVariantStore.getAt(0);
                    setArticlesTab.articleVariantComboBox.setValue(recordSelected.get('displayname'));
                    setArticlesTab.assignmentpanel.updateCurrentInformation(recordSelected);
                }
            },
        });
    },

});
