// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.model.Article', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int', defaultValue: 0 },
        { name: 'name', type: 'string', defaultValue: '' },
        { name: 'additional', type: 'string', defaultValue: '' },
        { name: 'articleDetailId', type: 'int', defaultValue: 0 },
        { name: 'articleId', type: 'int', defaultValue: 0 },
        { name: 'setId', type: 'int', defaultValue: 0 },
        { name: 'ordernumber', type: 'string', defaultValue: '' },
        { name: 'price', type: 'number', defaultValue: 0 },
        { name: 'tax', type: 'number', defaultValue: 0 },
        { name: 'description', type: 'string', defaultValue: '' },
        { name: 'quantity', type: 'int', defaultValue: 1 },
        { name: 'instock', type: 'int', defaultValue: 0 },
        { name: 'deliverytime', type: 'int', defaultValue: 0 },
        { name: 'laststock', type: 'bool', defaultValue: false },
        { name: 'active', type: 'bool', defaultValue: false },
        { name: 'maxpurchase', type: 'int', defaultValue: 0 },
        { name: 'weight', type: 'number', defaultValue: 0 },
        {
            name: 'displayname',
            type: 'string',
            convert: function (value, record) {
                if (!value) {
                    if (record.get('additional') !== '') {
                        value = record.get('name') + ', ' + record.get('additional');
                    } else {
                        value = record.get('name');
                    }
                }

                return value;
            },
        },
        {
            name: 'grossprice',
            type: 'number',
            convert: function (value, record) {
                return record.get('price') * (1 + (record.get('tax') / 100));
            },
        },
        {
            name: 'total',
            type: 'number',
            convert: function (value, record) {
                return record.get('grossprice') * record.get('quantity');
            },
        },
        {
            name: 'available',
            type: 'boolean',
            convert: function (value, record) {
                value = record.get('active')
                    && (!record.get('laststock') || (record.get('instock') >= record.get('quantity')));

                return value;
            },
        },
    ],

    set: function (fieldName) {
        this.callParent(arguments);
        if (fieldName === 'price' || fieldName === 'quantity') {
            var total = this.get('price') * this.get('quantity');
            this.set('total', total);
        }
    },

});
