// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.model.VariantList', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'articleDetailId', type: 'int' },
        { name: 'price', type: 'number' },
        { name: 'tax', type: 'number' },
        { name: 'ordernumber', type: 'string' },
        { name: 'name', type: 'string' },
        { name: 'additional', type: 'string' },
        {
            name: 'grossprice',
            type: 'number',
            convert: function (value, record) {
                if (!value) {
                    value = record.get('price') * (1 + (record.get('tax') / 100));
                }

                return value;
            },
        },
        {
            name: 'displayname',
            type: 'string',
            convert: function (value, record) {
                if (!value) {
                    if (record.get('additional') !== '') {
                        value = record.get('ordernumber') + ' - '
                            + record.get('name') + ', '
                            + record.get('additional');
                    } else {
                        value = record.get('ordernumber') + ' - ' + record.get('name');
                    }
                }

                return value;
            },
        },
    ],

});
