// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.view.detail.Tab', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_set_articles_article-view-detail-tab',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_set_articles_article_set_articles_tab/tab',

    border: false,
    layout: {
        type: 'vbox',
        align: 'stretch',
    },
    defaults: {
        collapsible: false,
        split: false,
        bodyPadding: 0,
    },
    height: '66%',
    header: false,
    width: '66%',

    initComponent: function () {
        this.setTitle(this.getViisonSnippet('tab/title'));
        this.articleVariantStore = Ext.create('Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.store.VariantList', {});
        this.articleVariantStore.getProxy().extraParams = {
            articleId: this.initialConfig.article.get('id'),
        };
        this.articleVariantComboBox = Ext.create('Ext.form.ComboBox', {
            fieldLabel: this.getViisonSnippet('tab/choose-variant'),
            width: 600,
            store: this.articleVariantStore,
            queryMode: 'local',
            region: 'west',
            editable: false,
            displayField: 'displayname',
            listeners: {
                scope: this,
                select: function (combo, records) {
                    this.assignmentpanel.updateCurrentInformation(records[0]);
                },
            },
        });
        this.articleVariantCopyButton = Ext.create('Ext.button.Button', {
            text: this.getViisonSnippet('tab/copy-variant'),
            region: 'east',
            cls: 'primary',
            height: 24,
            scope: this,
            handler: function () {
                Ext.Msg.confirm(
                    this.getViisonSnippet('tab/copy-variant/title'),
                    this.getViisonSnippet('tab/copy-variant/dialog'),
                    function (buttonId) {
                        if (buttonId === 'yes') {
                            this.assignmentpanel.copySelectionToAllVariants(this.articleVariantStore.data.items);
                        }
                    },
                    this
                );
            },
        });
        this.copyButtonPanel = new Ext.panel.Panel({
            border: false,
            region: 'east',
            bodyStyle: 'margin: 2px; padding: 0px 5px 0px 0px;',
            items: [
                this.articleVariantCopyButton,
            ],
        });

        // top variantSelectionPanel: variant dropdown selection
        this.variantSelectionPanel = new Ext.panel.Panel({
            header: false,
            border: false,
            region: 'north',
            height: 38,
            bodyStyle: 'margin: 5px;',
            layout: 'border',
            items: [
                this.articleVariantComboBox,
                this.copyButtonPanel,
            ],
        });

        // main Article-To-SetArticle AlignmentPanel
        this.assignmentpanel = Ext.create('Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.view.detail.AssignmentPanel', {});

        this.items = [
            this.variantSelectionPanel,
            this.assignmentpanel,
        ];

        this.on('afterrender', this.onAfterRender, this);
        Shopware.app.Application.on('moduleConnector:splitView', function (event, args) {
            this.updateView(event, args);
        }, this);
        this.callParent(arguments);
    },

    updateView: function (event, args) {
        if (Ext.isDefined(this.articleVariantStore)) {
            this.articleVariantStore.getProxy().extraParams = {
                articleid: args.articleId,
            };
            this.onAfterRender();
        }
    },

    /**
     * Load stores after tab has been rendered
     */
    onAfterRender: function () {
        this.articleVariantStore.load({
            scope: this,
            callback: function (records) {
                if (records.length > 0) {
                    var recordSelected = this.articleVariantStore.getAt(0);
                    this.articleVariantComboBox.setValue(recordSelected.get('displayname'));
                    this.assignmentpanel.updateCurrentInformation(recordSelected);
                }
            },
        });
    },

});
