// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * Adds a new tab for configuring an article set.
     */
    createMainTabPanel: function () {
        var tabPanel = this.callParent(arguments);

        // Register article set tab panel
        this.registerAdditionalTab({
            title: ViisonCommonApp.getSnippet('tab/title', 'backend/viison_set_articles_article_set_articles_tab/window'),
            tabConfig: {
                name: 'viison_set_articles-tab',
            },
            contentFn: this.createViisonSetArticleTab,
            scope: this,
        });

        return tabPanel;
    },

    /**
     * Creates the set article tab and its controller.
     *
     * @param article
     * @param stores
     * @param eOpts
     */
    createViisonSetArticleTab: function (article, stores, eOpts) {
        // Create main controller
        this.subApplication.addController({
            name: 'Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.controller.Main',
        });

        // Create tab panel and enable it, if the loaded article already exists
        this.viisonSetArticlesTab = Ext.create('Shopware.apps.ViisonSetArticlesArticleSetArticlesTab.view.detail.Tab', {
            article: article,
        });
        eOpts.tab.add(this.viisonSetArticlesTab);
        this.updateViisonSetArticlesTab();
    },

    /**
     * Disables the set articles tab, if the article has not been created yet.
     */
    updateViisonSetArticlesTab: function () {
        this.viisonSetArticlesTab.setDisabled(this.article.get('id') === null);
    },

});
