// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesArticleSettingsFields.view.detail.Settings', {

    override: 'Shopware.apps.Article.view.detail.Settings',

    // Soft disabled fields are greyed but are still editable
    softDisabledFieldNames: [
        'mainDetail[inStock]',
        'mainDetail[stockMin]',
        'mainDetail[maxPurchase]',
        'mainDetail[shippingTime]',
        'mainDetail[releaseDate]',
        'mainDetail[weight]',
    ],
    // "hard" disabled fields are simply disabled
    disabledFieldNames: [
        'lastStock',
    ],

    /**
     * @override
     */
    onStoresLoaded: function (article) {
        this.callParent(arguments);

        // Do not disable any fields, if article is no SetArticle
        if (!article.getMainDetail().first() || !article.getMainDetail().first().get('viisonSetarticleActive')) {
            return;
        }

        var fields = this.query('field');
        fields.forEach(function (field) {
            if (this.softDisabledFieldNames.indexOf(field.name) > -1) {
                this.viisonSetArticleSoftDisableField(field);
            } else if (this.disabledFieldNames.indexOf(field.name) > -1) {
                this.viisonSetArticleDisableField(field);
            }
        }, this);

        // Init quicktips (tooltips)
        Ext.QuickTips.init();
    },

    /**
     * Soft disables the given field by showing the set article field icon. Also adds a hint text.
     *
     * @param Ext.form.field.Base field
     */
    viisonSetArticleSoftDisableField: function (field) {
        if (field === null) {
            return;
        }

        field.getEl().select('.x-form-item-body').first().dom.classList.add('set-article-specific');
        field.getEl().set({
            'data-qtip': ViisonCommonApp.getSnippet('tab/soft-disabled-field-hint', 'backend/viison_set_articles_article_settings_fields/main'),
        });
    },

    /**
     * Disables the given field. Also adds a hint text. Also displays the set article field icon.
     *
     * @param Ext.form.field.Base field
     */
    viisonSetArticleDisableField: function (field) {
        if (field === null) {
            return;
        }

        field.setDisabled(true);
        field.getEl().select('.x-form-item-body').first().dom.classList.add('set-article-specific');
        field.getEl().set({
            'data-qtip': ViisonCommonApp.getSnippet('tab/hard-disabled-field-hint', 'backend/viison_set_articles_article_settings_fields/main'),
        });
    },

});
