// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * This window extension is necessary if ViisonPickwareERP is active, because it introduces a new stock field set
 * where we need to manipulate the storage fields
 */
Ext.define('Shopware.apps.ViisonSetArticlesArticleSettingsFields.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * @Override
     */
    onStoresLoaded: function (article) {
        this.callParent(arguments);

        // Do not manipulate any fields, if article is no set article
        if (!article.getMainDetail().first() || !article.getMainDetail().first().get('viisonSetarticleActive')) {
            return;
        }
        // Check if the stock field set can be found
        var stockFieldSet = this.down('viison_pickware_erp_article_stock_field_set-stock_field_set');
        if (!stockFieldSet) {
            return;
        }

        // Show the set articles icon outside the stock field grid
        stockFieldSet.getEl().dom.classList.add('set-article-specific');

        // Disable and show hint on all checkboxes (right panel)
        var checkboxes = stockFieldSet.getEl().select('.x-form-cb-wrap');
        checkboxes.elements.forEach(function (field) {
            field.classList.add('set-article-specific');
        }, this);

        // Add hint to the onSaleField (laststock), since the other checkbox is handled in
        // Shopware.apps.ViisonSetArticlesArticle.view.detail.Base. Disable the form field
        // since the laststock flag is overwritten in the ArticleSubscriber.
        stockFieldSet.onSaleField.setDisabled(true);
        stockFieldSet.onSaleField.getEl().dom.classList.add('x-item-disabled');
        stockFieldSet.onSaleField.getEl().set({
            'data-qtip': ViisonCommonApp.getSnippet('tab/hard-disabled-field-hint', 'backend/viison_set_articles_article_settings_fields/main'),
        });
    },
});
