// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesArticleSettingsFields.view.variant.Detail', {

    override: 'Shopware.apps.Article.view.variant.Detail',

    // Soft disabled fields are greyed but are still editable
    softDisabledFieldNames: [
        'inStock',
        'stockMin',
        'maxPurchase',
        'shippingTime',
        'weight',
        'releaseDate',
    ],
    // "hard" disabled fields are simply disabled
    disabledFieldNames: [
        'weight',
        'lastStock',
    ],

    /**
     * @override
     */
    initComponent: function () {
        this.callParent(arguments);
        this.on('afterrender', function () {
            if (this.record && this.record.data.viisonSetarticleActive) {
                this.viisonDisableFormFields();
            }
        });
    },

    /**
     * Disables some of the setting fields which should not be manipulated if the current article is a set article.
     */
    viisonDisableFormFields: function () {
        var fields = this.query('field');
        fields.forEach(function (field) {
            if (this.softDisabledFieldNames.indexOf(field.name) > -1) {
                this.viisonSetArticleSoftDisableField(field);
            } else if (this.disabledFieldNames.indexOf(field.name) > -1) {
                this.viisonSetArticleDisableField(field);
            }
        }, this);

        // Check if the stock field set can be found
        var stockFieldSet = this.down('viison_pickware_erp_article_stock_field_set-stock_field_set');
        if (stockFieldSet) {
            stockFieldSet.getEl().dom.classList.add('set-article-specific');
            if (typeof stockFieldSet.setAvailableStockEditingHidden === 'function') {
                // Shopware ERP < 4.1.0
                stockFieldSet.setAvailableStockEditingHidden(true);
            } else {
                var stockGrid = stockFieldSet.stockGrid;
                var availableStockRecord = stockGrid.store.getAt(stockGrid.store.findExact('id', 'availableStock'));
                availableStockRecord.set('editingEnabled', true);
            }

            // Enable the "stock management disabled" field only if flag was inactive (to avoid unintentional confirm
            // messages). Also check the legacy (Pickware < 5.0.0) viisonNotRelevantForStockManager field.
            var wasStockManagementDisabled = (
                this.record.data.viisonStockManagementDisabled
                || this.record.data.viisonNotRelevantForStockManager
            );
            if (!wasStockManagementDisabled) {
                stockFieldSet.notStockManagedField.setValue(true);
            }
            stockFieldSet.notStockManagedField.setReadOnly(true);
            // Disable laststock in any case and disable the whole field with a tooltip
            this.viisonSetArticleSoftDisableField(stockFieldSet.onSaleField);
        }

        // Init quicktips (tooltips)
        Ext.QuickTips.init();
    },

    /**
     * Soft disables the given field by showing the set article field icon. Also adds a hint text.
     *
     * @param Ext.form.field.Base field
     */
    viisonSetArticleSoftDisableField: function (field) {
        if (field === null) {
            return;
        }

        if (field.getEl()) {
            field.getEl().select('.x-form-item-body').first().dom.classList.add('set-article-specific');
            field.getEl().set({
                'data-qtip': ViisonCommonApp.getSnippet('tab/soft-disabled-field-hint', 'backend/viison_set_articles_article_settings_fields/main'),
            });
        }
    },

    /**
     * Disables the given field. Also adds a hint text. Also displays the set article field icon.
     *
     * @param Ext.form.field.Base field
     */
    viisonSetArticleDisableField: function (field) {
        if (field === null) {
            return;
        }

        field.setDisabled(true);
        field.getEl().select('.x-form-item-body').first().dom.classList.add('set-article-specific');
        field.getEl().set({
            'data-qtip': ViisonCommonApp.getSnippet('tab/hard-disabled-field-hint', 'backend/viison_set_articles_article_settings_fields/main'),
        });
    },
});
