// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesOrderPosition.view.detail.Position', {

    override: 'Shopware.apps.Order.view.detail.Position',

    /**
     * @override
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Find index of last actionColumn in columns array
        var actionColumnIndex = -1;
        Ext.Array.each(columns, function (item, index) {
            if (item.xtype === 'actioncolumn') {
                actionColumnIndex = index;
            }
        });

        if (actionColumnIndex > -1) {
            var actionColumn = columns[actionColumnIndex];
            // Add set article indicator icon that has no handler but only a tooltip
            var setArticleIndicatorIcon = {
                action: 'viisonSetArticleIndicator',
                iconCls: 'viison-is-part-of-set-article',
                tooltip: ViisonCommonApp.getSnippet(
                    'position/action/isPartOfSetArticle',
                    'backend/viison_set_articles_order_position/main'
                ),
                // Disable (set hidden) the whole icon if the position is not part of a set article position
                getClass: function (value, metadata, record) {
                    var isSetArticle = record.data.viisonSetarticleOrderid !== null
                        && Number(record.data.viisonSetarticleOrderid) !== 0;

                    return isSetArticle ? '' : 'x-hidden';
                },
            };
            actionColumn.items.push(setArticleIndicatorIcon);
        }

        return columns;
    },

});
