// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonSetArticlesShipping.view.edit.Advanced', {

    override: 'Shopware.apps.Shipping.view.edit.Advanced',

    /**
     * Adds a hint to the "own (SQL) rule" of the shipping price calculation to help handling set article weights.
     */
    getFormElementsRight: function () {
        var items = this.callParent(arguments);

        Ext.Array.each(items, function (item) {
            if (item.name === 'calculationSql') {
                item.helpText = ViisonCommonApp.getSnippet('sqlcalculation/hint', 'backend/viison_set_articles_shipping/main');

                return false; // break
            }

            return true; // continue
        });

        return items;
    },

});
