<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions;

use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class NumberRangeNotFoundException extends \Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @param string $numberRangeName Name of the missing number range
     */
    public function __construct($numberRangeName)
    {
        $message = sprintf(
            'The number range with the name "%s" does not exist. ' .
            'Please create a number range with the given name and try again.',
            $numberRangeName
        );
        parent::__construct($message);

        $this->setSnippetName('number_range_not_found');
        $this->setSnippetNamespace('exceptions/viison_common/main');
        $this->setSnippetArguments([$numberRangeName]);
    }
}
