<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions\ValidationExceptions;

use Exception;

class EntityNotFoundException extends AbstractValidationException
{
    /**
     * @param string $parameterName
     * @param string $modelClassName
     * @param mixed $entityIdentifier
     * @param Exception|null $previousException
     */
    public function __construct($parameterName, $modelClassName, $entityIdentifier, Exception $previousException = null)
    {
        $message = sprintf(
            'Entity of class "%s" identified by parameter %s=%s was not found.',
            $modelClassName,
            $parameterName,
            (string) $entityIdentifier
        );

        parent::__construct(
            $message,
            'entityNotFoundException',
            [
                $modelClassName,
                $parameterName,
                $entityIdentifier,
            ],
            $previousException
        );
    }
}
