<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes;

use Shopware\Plugins\ViisonCommon\Classes\Util\Util;

/**
 * This is a helper class for rendering grid layout based documents. That is,
 * documents which have a certain number of rows and columns. It provides methods
 * to render the HTML of the document as well as a mPDF document, which can be
 * displayed in the browser as a PDF file.
 *
 * @deprecated Use Shopware\Plugins\ViisonCommon\Classes\Document\RenderingContext\GridLayoutRenderingContext instead
 */
class GridDocumentRenderer
{
    /**
     * Renders the HTML of the document using 'renderHTML()' and passes that HTML to
     * Dompdf to create a new PDF files with the given format, which is finally returned.
     * In order to display the Dompdf document in the browser, just call
     *
     * $dompdf = ViisonCommon_Classes_GridDocumentRenderer::renderPDF(...);
     * $dompdf->stream('filename.pdf');
     *
     * @param string $templatePath The absolute path to the template, that will be rendered.
     * @param string $layout The layout of the label paper, e.g. '4x12', '5x16'
     * @param array $items An array of items, which will be rendered. The content of the array is arbitrary.
     * @param int $offsetX (optional) The horizontal offset of the first cell that should be filled.
     * @param int $offsetY (optional) The vertical offset of the first cell that should be filled.
     * @param string $format (optional) The paper format, which will be used to render the PDF file.
     * @param array $extraTemplateParams An associative array containing extra parameters to be passed to the template.
     * @return \Dompdf\Dompdf The rendered mPDF document.
     * @deprecated Use Shopware\Plugins\ViisonCommon\Classes\Document\RenderingContext\GridLayoutRenderingContext instead
     */
    public static function renderPDF($templatePath, $layout, array $items, $offsetX = 0, $offsetY = 0, $format = 'A4', array $extraTemplateParams = [])
    {
        // Create a new PDF file using the rendered HTML
        $html = self::renderHTML($templatePath, $layout, $items, $offsetX, $offsetY, $extraTemplateParams);

        $dompdf = Util::createDompdfInstance();
        $dompdf->setPaper($format);
        $dompdf->loadHtml($html);
        $dompdf->render();

        return $dompdf;
    }

    /**
     * Loads the template from the given path and assigns both the offset and the items
     * to it, before it renders the HTML and returns it.
     *
     * @param string $templatePath The absolute path to the template, that will be rendered.
     * @param string $layout The layout of the label paper, e.g. '4x12', '5x16'
     * @param array $items An array of items, which will be rendered. The content of the array is arbitrary.
     * @param int $offsetX (optional) The horizontal offset of the first cell that should be filled.
     * @param int $offsetY (optional) The vertical offset of the first cell that should be filled.
     * @param array $extraTemplateParams An associative array containing extra parameters to be passed to the template.
     * @return string The HTML of the rendered document.
     * @deprecated Use Shopware\Plugins\ViisonCommon\Classes\Document\RenderingContext\GridLayoutRenderingContext instead
     */
    public static function renderHTML($templatePath, $layout, array $items, $offsetX = 0, $offsetY = 0, array $extraTemplateParams = [])
    {
        // Render the document to HTML
        $templateEngine = Util::cloneTemplateManager(Shopware()->Template());

        // The template differs depending on the layout, so make sure that different caches are used per layout
        $templateEngine->compile_id = $layout;
        $template = $templateEngine->createTemplate($templatePath);
        $template->assign('offsetX', $offsetX);
        $template->assign('offsetY', $offsetY);
        $template->assign('items', $items);
        $template->assign('layout', $layout);
        $template->addTemplateDir(__DIR__ . '/../Views/documents');
        $template->addTemplateDir(dirname($templatePath));
        foreach ($extraTemplateParams as $key => $value) {
            $template->assign($key, $value);
        }
        $html = $template->fetch();

        return $html;
    }
}
