<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Installation\Document;

use Zend_Db_Adapter_Abstract;

class UninstallationHelper
{

    /**
     * @var Zend_Db_Adapter_Abstract $db
     */
    private $db;

    /**
     * @param Zend_Db_Adapter_Abstract $db
     */
    public function __construct(Zend_Db_Adapter_Abstract $db)
    {
        $this->db = $db;
    }

    /**
     * Remove a document type and all its boxes. Does nothing if the document type was not found.
     *
     * @param string $documentName the name of the document type to remove
     *
     * @deprecated document types should not be removed on uninstallation because that may leave the documents tab
     *             broken
     */
    public function removeDocumentTypeIfExists($documentName)
    {
        // no-op (deprecated, just do nothing instead)
    }

    public function getDocumentId($documentTypeName)
    {
        return $this->db->fetchOne(
            'SELECT id
                     FROM s_core_documents
                     WHERE `name` = ?',
            [$documentTypeName]
        );
    }
}
