<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Installation;

use Shopware\Plugins\ViisonCommon\Classes\Localization\BootstrapSnippetManager;

/**
 * Helpers for formatting informative messages displayed during plugin installation.
 */
class InstallationMessageUtil
{

    /**
     * Formats an informative update message including the hint to clear all caches and reload the backend that should
     * be returned from plugin bootstrap install/update/uninstall/activate/deactivate methods.
     *
     * @param array $updateHints any extra bullet points to put in the message
     * @return string a message that can be return from the plugin bootstrap methods
     */
    public static function formatUpdateMessage($updateHints = [])
    {
        $snippetManager = new BootstrapSnippetManager(Shopware()->Container(), __DIR__ . '/../../Snippets/');
        $snippetNamespace = $snippetManager->getNamespace('bootstrap/viison_common/installer_message');

        if (empty($updateHints)) {
            return $snippetNamespace->get('clear_cache_and_refresh');
        }

        $separator = $snippetNamespace->get('update_hint_separator');

        return $snippetNamespace->get('update_hint_prefix') . implode($separator, $updateHints) . $separator . $snippetNamespace->get('clear_cache_and_refresh');
    }
}
