<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\PluginConfigImport;

use Exception;
use Symfony\Component\Yaml\Yaml;

class PluginConfigReader
{
    /**
     * Extracts the data from the config YAML file at the given $configPath.
     *
     * @param string $configPath
     * @return array
     * @throws Exception
     */
    protected function getConfigFileData($configPath)
    {
        if (!file_exists($configPath)) {
            throw new Exception('Config file does not exist.');
        }

        $configPathInfo = pathinfo($configPath);
        $extension = $configPathInfo['extension'];
        if ($extension !== 'yaml' && $extension !== 'yml') {
            throw new Exception('Config file is no yaml file.');
        }

        $configFileContents = file_get_contents($configPath);

        try {
            $configurationWrapper = Yaml::parse($configFileContents);
        } catch (Exception $exception) {
            throw new Exception('Config file is not valid yaml.', 0, $exception);
        }

        return $configurationWrapper;
    }
}
