<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagImportExport;

use Shopware\Components\Model\ModelManager;
use Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagImportExport\SwagImportExportVersion2\SwagDataDbAdapter;
use Shopware_Components_Config as Config;
use Shopware_Components_Snippet_Manager as SnippetManager;

abstract class AbstractDbAdapter implements SwagDataDbAdapter
{
    /**
     * @var ModelManager
     */
    protected $entityManager;

    /**
     * @var SnippetManager
     */
    protected $snippetManager;

    /**
     * @var string
     */
    protected $errorMode;

    /**
     * @var array
     */
    protected $unprocessedData;

    /**
     * @var array
     */
    protected $logMessages;

    /**
     * @var string
     */
    protected $logState;

    /**
     * @param Config $config
     * @param ModelManager $entityManager
     * @param SnippetManager $snippetManager
     */
    public function __construct(Config $config, ModelManager $entityManager, SnippetManager $snippetManager)
    {
        $this->entityManager = $entityManager;
        $this->snippetManager = $snippetManager;
        $this->errorMode = $config->get('SwagImportExportErrorMode');
    }

    /**
     * @inheritdoc
     */
    public function getColumns($section)
    {
        $method = 'get' . ucfirst($section) . 'Columns';
        if (method_exists($this, $method)) {
            return $this->{$method}();
        }

        return false;
    }

    /**
     * @inheritdoc
     */
    public function getUnprocessedData()
    {
        return $this->unprocessedData;
    }

    /**
     * @inheritdoc
     */
    public function getLogMessages()
    {
        return isset($this->logMessages) ? $this->logMessages : [];
    }

    /**
     * @inheritdoc
     */
    public function getLogState()
    {
        return $this->logState;
    }

    /**
     * @param string $message
     * @throws \Exception
     */
    protected function saveMessage($message)
    {
        if ($this->errorMode === false) {
            throw new \Exception($message);
        }

        $this->logMessages[] = $message;
        $this->logState = 'true';
    }
}
